import json
import os
from typing import Any, Iterable, List, Dict, Tuple
from jpype import JArray, JString, JInt
from prompta.utils.java_libs import Alphabets
from prompta.core.language import BaseLanguage


class BaseOracle:
    def __init__(self, language: BaseLanguage, *args: Any, **kwargs: Any) -> None:
        self.language = language
        self.exp_dir = None
        self.query_history = {}

    def reset(self, language: BaseLanguage, exp_dir: str, alphabet=None, load_history=False):
        self.language = language
        self.exp_dir = exp_dir
        assert exp_dir is not None

        if not os.path.exists(exp_dir):
            os.mkdir(exp_dir)
        self.query_history = {}

    @property
    def alphabet(self):
        return self.language.alphabet
    
    @property
    def jalphabet(self):
        return Alphabets.fromArray(JArray(JString)(self.language.alphabet))
    
    @property
    def jalphabet_as_ints(self):
        return Alphabets.fromArray(*JArray(JInt)([_ for _ in range(len(self.language.alphabet))]))
    
    @property
    def name(self):
        return type(self).__name__
    
    @property
    def membership_query_cache(self):
        return self.query_history

    def __call__(self, input_str: str, *args: Any, **kwds: Any):
        raise NotImplementedError

    def check_conjecture(self, aut, _type=str) -> Tuple[Tuple[str]]:
        raise NotImplementedError
